/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.brewing;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.brewing.ActionBrewingBase;
import com.blamejared.crafttweaker.mixin.common.access.brewing.AccessPotionBrewing;
import com.blamejared.crafttweaker.natives.item.alchemy.ExpandPotion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.registries.IRegistryDelegate;

public class ActionRemoveBrewingRecipeByPotionOutput
extends ActionBrewingBase {
    private final List<PotionBrewing.Mix<Potion>> removed = new ArrayList<PotionBrewing.Mix<Potion>>();
    private final Potion output;

    public ActionRemoveBrewingRecipeByPotionOutput(List<IBrewingRecipe> recipes, Potion output) {
        super(recipes);
        this.output = output;
    }

    @Override
    public void apply() {
        Iterator<PotionBrewing.Mix<Potion>> iterator = AccessPotionBrewing.crafttweaker$getPOTION_MIXES().iterator();
        while (iterator.hasNext()) {
            PotionBrewing.Mix<Potion> mix = iterator.next();
            if (mix.f_43534_ == null) {
                throw new RuntimeException("Error getting potion from mix: " + mix + "! Please make an issue on the issue tracker!");
            }
            if (!((Potion)mix.f_43534_.get()).equals(this.output)) continue;
            this.removed.add(mix);
            iterator.remove();
        }
    }

    @Override
    public void undo() {
        for (PotionBrewing.Mix<Potion> potion : this.removed) {
            IRegistryDelegate potionInput = potion.f_43532_;
            Ingredient itemReagent = potion.f_43533_;
            IRegistryDelegate potionOutput = potion.f_43534_;
            if (potionInput == null || itemReagent == null || potionOutput == null) {
                CraftTweakerAPI.LOGGER.error("Error getting mix entries! potionInput: {}, itemReagent: {}, potionOutput: {}", (Object)potionInput, (Object)itemReagent, (Object)potionOutput);
                continue;
            }
            AccessPotionBrewing.crafttweaker$callAddMix((Potion)potionInput.get(), itemReagent.m_43908_()[0].m_41720_(), (Potion)potionOutput.get());
        }
    }

    @Override
    public String describe() {
        return "Removing Brewing recipes that output: " + ExpandPotion.getCommandString(this.output);
    }

    @Override
    public String describeUndo() {
        return "Undoing removal of Brewing recipes that output: " + ExpandPotion.getCommandString(this.output);
    }
}

